/* 
 *  WrapUpTimer.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

public class WrapUpTimer extends InteractionTimer {

    private static final Logger LOG = Logger.getLogger(WrapUpTimer.class);

    public WrapUpTimer(int timerLength, String interactionID, InteractionDataGUI gui) {
        super(timerLength, "WrapUpTimer", interactionID, gui);
        LOG.trace("Timer started:" + timerLength);
    }

    @Override
    public void executeExpiryAction() {
        LOG.info("Wrap Timer expired, wrapup interaction:" + getInteractionID());
        InteractionExecutor.getInteractionExe().wrapUP(getInteractionID());
    }

}
